/*** 1.   ũƮ ***/

SELECT number custid
	, NEWID() code
	, CASE WHEN number <= 10  THEN 5
	  WHEN number <= 110 THEN 4
	  WHEN number <= 410 THEN 3
	  WHEN number <= 710 THEN 2
	  ELSE 1 END level 
INTO TB_Cust02
FROM master..spt_values
WHERE type = 'P'
AND number BETWEEN 1 AND 1000

SELECT a.custid, DATEADD(dd,b.number,'2000-01-01') date 
INTO TB_Pay02		
FROM TB_Cust02 a, master..spt_values b
WHERE b.type = 'P'
AND b.number BETWEEN 1 AND 1000
AND ((level IN (5,4) AND custid%2=0) OR (level IN (3,2,1) AND custid%100<>0 ))

CREATE INDEX NIDX01_Cust02 ON TB_Cust02 (level) INCLUDE (custid)
CREATE INDEX NIDX01_Pay02 ON TB_Pay02 (date) INCLUDE (custid)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT custid
FROM TB_Cust02
WHERE level = 5
INTERSECT 
SELECT custid
FROM TB_Pay02
WHERE date >= '2001-01-01'
GO


/*** 6. [TO-BE]   ***/

--ε  
CREATE INDEX NIDX02_Pay02 ON TB_Pay02 (custid,date) 
GO

--SQL 
SELECT custid
FROM TB_Cust02 c
WHERE level = 5
AND EXISTS (SELECT 'x'
	       FROM TB_Pay02 p
	       WHERE c.custid = p.custid 
	       AND date >= '2001-01-01')
GO